<?php defined('_JEXEC') or die(file_get_contents('index.html'));
/**
 * @package   Fox Contact for Joomla
 * @copyright Copyright (c) 2010 - 2015 Demis Palma. All rights reserved.
 * @license   Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
 * @see       Documentation: http://www.fox.ra.it/forum/2-documentation.html
 */
jimport('foxcontact.action.email');

class FoxActionEmailAdmin extends FoxActionEmail
{
	protected $type = 'Administrators notification email';
	
	protected function isEnable()
	{
		$all_recipients = array_merge($this->getRecipients('to_address'), $this->getRecipients('cc_address'), $this->getRecipients('bcc_address'));
		return count($all_recipients) > 0;
	}
	
	
	protected function prepare($mail)
	{
		$render = $this->form->getMessageRender(false);
		$this->setFrom($mail, '', $this->form->getName(), $this->form->getEmail(), $this->form->getName());
		$this->setTo($mail, 'to_address', 'addRecipient');
		$this->setTo($mail, 'cc_address', 'addCC');
		$this->setTo($mail, 'bcc_address', 'addBCC');
		$mail->setSubject($render->renderSubject('email_subject'));
		$mail->Encoding = 'quoted-printable';
		$mail->setBody($render->renderBody('email_body'));
		$this->prepareAlternateBody($mail);
		$this->addAttachments($mail);
	}
	
	
	private function setTo($mail, $param_name, $method)
	{
		$recipients = $this->getRecipients($param_name);
		foreach ($recipients as $recipient)
		{
			$mail->{$method}(JMailHelper::cleanAddress($recipient));
		}
	
	}
	
	
	private function getRecipients($param_name)
	{
		$recipients = array();
		$list = $this->params->get($param_name, null);
		$list = !empty($list) ? explode(',', $list) : array();
		foreach ($list as $recipient)
		{
			$recipient = trim($recipient);
			if (!empty($recipient))
			{
				$recipients[] = $recipient;
			}
		
		}
		
		return $recipients;
	}

}