<?php defined('_JEXEC') or die(file_get_contents('index.html'));
/**
 * @package   Fox Contact for Joomla
 * @copyright Copyright (c) 2010 - 2015 Demis Palma. All rights reserved.
 * @license   Distributed under the terms of the GNU General Public License GNU/GPL v3 http://www.gnu.org/licenses/gpl-3.0.html
 * @see       Documentation: http://www.fox.ra.it/forum/2-documentation.html
 */

class FoxStructManager
{
	private static $version = null;
	
	public static function check($json)
	{
		$array = json_decode($json, true);
		$current = ucfirst(strtolower(str_ireplace('.', '_', isset($array['version']) ? $array['version'] : 'none')));
		if (method_exists(__CLASS__, "up{$current}"))
		{
			$array = forward_static_call(array(__CLASS__, "up{$current}"), $array);
		}
		
		$array['version'] = self::getVersion();
		return $array;
	}
	
	
	public static function upNone($array)
	{
		return $array;
	}
	
	
	public static function up3_5_0($array)
	{
		self::fixItem($array, 'text_area', function (&$item)
		{
			if ($item['height']['unit'] === 'inherited')
			{
				$item['height']['unit'] = 'auto';
			}
		
		});
		return $array;
	}
	
	
	private static function fixItem(&$array, $type, $function)
	{
		foreach ($array['rows'] as &$row)
		{
			foreach ($row['columns'] as &$column)
			{
				foreach ($column['items'] as &$item)
				{
					if ($item['type'] === $type)
					{
						$function($item);
					}
				
				}
			
			}
		
		}
	
	}
	
	
	public static function getVersion()
	{
		if (is_null(self::$version))
		{
			$xml = new SimpleXMLElement(JPATH_ADMINISTRATOR . '/components/com_foxcontact/foxcontact.xml', 0, true);
			self::$version = (string) $xml->version;
		}
		
		return self::$version;
	}

}